﻿/****** Object:  View [dbo].[ViwSellFactorTruckWeight]    Script Date: 25/1/2025 01:40:40 ب.ظ ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


ALTER VIEW [dbo].[ViwSellFactorTruckWeight]
AS
SELECT  Factor.ID, Factor.Number, 
		SUM(Case WHEN COALESCE(Trucks.DocItemID,0)=0 THEN COALESCE (Trucks.Weigh, 0) ELSE 0 END) as UnDocumentedTrucks,
		SUM(Case WHEN COALESCE(Trucks.DocItemID,0)=0 THEN 0 ELSE COALESCE (Trucks.Weigh, 0) END) as DocumentedTrucks,
		Factor.OrderDate, Factor.OrderTotalID, Factor.OrderControlID, Factor.OrderDetailID1, Factor.OrderDetailID2, 
		  Factor.BuyerTotalID, Factor.BuyerControlID, Factor.BuyerDetailID1, Factor.BuyerDetailID2, Factor.SellerTotalID, Factor.SellerControlID, 
		  Factor.SellerDetailID1, Factor.SellerDetailID2, Factor.Request, Factor.SendDate, Factor.ControlA, Factor.ControlB, Factor.ControlC, Factor.ControlD, 
		  Factor.SellType, Factor.SellTime, Factor.SellPrice, Factor.BuyType, Factor.BuyTime, Factor.BuyPrice
FROM         dbo.AccSellFactor AS Factor WITH (NOLOCK) LEFT OUTER JOIN
                      dbo.AccSellFactorTrucks AS Trucks WITH (NOLOCK) ON Factor.ID = Trucks.SellFactorID
WHERE     (COALESCE (Trucks.Status, 0) = 0)
GROUP BY Factor.ID, Factor.Number, Factor.OrderDate, Factor.OrderTotalID, Factor.OrderControlID, Factor.OrderDetailID1, Factor.OrderDetailID2, 
                      Factor.BuyerTotalID, Factor.BuyerControlID, Factor.BuyerDetailID1, Factor.BuyerDetailID2, Factor.SellerTotalID, Factor.SellerControlID, 
                      Factor.SellerDetailID1, Factor.SellerDetailID2, Factor.Request, Factor.SendDate, Factor.ControlA, Factor.ControlB, Factor.ControlC, Factor.ControlD, 
                      Factor.SellType, Factor.SellTime, Factor.SellPrice, Factor.BuyType, Factor.BuyTime, Factor.BuyPrice
GO


